/* $Id: source2.c,v 1.6 1998/07/20 22:35:51 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

/* The source to be tested must be in module with LA of 8 and
   sema.bin must be installed into module 8 before running this program */

#include <stdio.h>		/* For printf */
#include <stdlib.h>		/* For exit */
#include <unistd.h>		/* For sleep */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    struct e1432_hwconfig hwconfig;
    int     nsource;
    SHORTSIZ16 gsource;
    SHORTSIZ16 lsource[1];
    SHORTSIZ16 laddr = 8;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    if (hwconfig.source_chans == 0)
    {
	(void) printf("No source found!\n");
	exit(1);
    }
    nsource = 1;
    lsource[0] = E1432_SOURCE_CHAN(1);
    gsource = e1432_create_channel_group(hw, nsource, lsource);
    if (gsource >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    gsource));
	return -1;
    }

    /* 5 Volt, 5 KHz sine, 6.4 KHz filter, with SUM input on */
    CHECK(e1432_set_active(hw, gsource, E1432_CHANNEL_ON));
    CHECK(e1432_set_range(hw, gsource, 10));
    CHECK(e1432_set_amp_scale(hw, gsource, 0.5));
    CHECK(e1432_set_filter_freq(hw, gsource, 6400));
    CHECK(e1432_set_sine_freq(hw, gsource, 5000));
    CHECK(e1432_set_source_cola(hw, gsource, E1432_SOURCE_COLA_OFF));
    CHECK(e1432_set_source_sum(hw, gsource, E1432_SOURCE_SUM_ON));

    /* Start measurement, which also starts the source */
    for ( ; ; )
    {
	CHECK(e1432_init_measure(hw, gsource));
	(void) sleep(1);
    }
    /*NOTREACHED*/
    return 0;
}
